# Template de projet Web avec Gulp + BrowserSync

Ce dépôt contient une configuration de base pour automatiser le traitement de fichiers SCSS et JS dans vos projets PHP, avec rafraîchissement automatique grâce à **BrowserSync**.

---

## 🧰 Prérequis

- [Node.js](https://nodejs.org/) installé
- Un environnement local configuré (ex. Laragon, MAMP, Valet)
- Un domaine local de type `monprojet.localhost` (le nom du dossier courant)

---

## 📦 Installation

Dans le dossier de ton projet :

```bash
npm install
```

---

## 🚀 Démarrer le projet

```bash
gulp
```

Cela va :
- Compiler `src/scss/main.scss` → `css/main.css` (minifié + autoprefixé)
- Compiler et minifier les fichiers JS de `src/js/` → `js/main.js`
- Lancer un serveur local avec BrowserSync à l’URL : `nomduprojet.localhost`
- Surveiller les changements dans `.scss`, `.js` et `.php`

---

## 🗂 Structure du projet

```
├── css/
│   └── main.css         → CSS généré automatiquement
├── js/
│   └── main.js          → JS généré automatiquement
├── src/
│   ├── js/              → Scripts source
│   │   └── *.js
│   └── scss/            → SCSS source
│       └── main.scss
├── *.php                → Vos fichiers PHP
├── gulpfile.js          → Configuration Gulp
├── package.json         → Dépendances
```

---

## ⚙️ Configuration automatique du proxy

Le proxy de BrowserSync est généré automatiquement à partir du nom du dossier actuel :

```js
const projectFolderName = path.basename(__dirname);
const browserSyncProxy = `${projectFolderName}.localhost`;
```

Assurez-vous d’avoir un domaine local correspondant configuré dans votre outil de développement (ex. dans Laragon > Menu > Ajouter un hôte virtuel).

---

## 🛠 Commandes utiles

- `npm install` : installe les dépendances
- `gulp` : démarre le serveur + compile SCSS et JS + live reload
- `CTRL+C` : arrêter le serveur Gulp

---

## ✏️ Personnalisation

Tu peux modifier :
- Le fichier d’entrée SCSS dans `paths.styles.src`
- Les fichiers JS à concaténer dans `paths.scripts.src`
- Les chemins de sortie CSS et JS

---

## 🧹 Nettoyage

> Les fichiers générés (`css/main.css`, `js/main.js`) peuvent être ajoutés à `.gitignore` si tu veux éviter de les suivre dans Git.

---

## 📄 Licence

Libre d’utilisation pour usage personnel ou professionnel.