<?php define('ROOT_PATH', $_SERVER['DOCUMENT_ROOT']. '/'); ?>
<?php 
    $menu = [
        [
            "path" => "/",
            "text" => "Accueil",
            "class" => "",
        ],

        [
            "path" => "",
            "text" => "Produits",
            "class" => "has-menu",
            "submenu" => [
                [
                    "path" => "",
                    "text" => "Tuyaux",
                    "img" => "icone.jpg",
                ],
            ]
        ],

        [
            "path" => "",
            "text" => "Politique de confidentialité",
            "class" => "hide",
        ],
    ];

    $langue = "fr" 
?>
<?php include (ROOT_PATH."inc/langue.php"); ?>

<header class="header">
    <div class="header-screen">
        <div class="container-90 flex flex-row">
            <div class="col-1">
                <a href="/" class="logo">
                    <img alt="">
                </a>
            </div>
            <div class="col-2">
                <nav>
                    <ul>
                        <?php
                            foreach($menu as $menuItem){ ?>
                                <li class="<?php if(!empty($menuItem['class'])) 
                                        { 
                                            echo($menuItem['class']);
                                        } 
                                        if($lapage == preg_replace('#^/fr/#', '' , $menuItem['path'])){
                                            if(!empty($menuItem['class'])){
                                                echo ' ';
                                            }
                                            echo 'actif';
                                        }
                                    ?>">
                                    <a href="<?= $menuItem['path'] ?>"><?= $menuItem["text"] ?></a>
                                    <hr>
                                    <?php if(!empty($menuItem["submenu"])){ ?>
                                        <div class="invisible"></div>
                                        <ul class="submenu">
                                            <?php foreach($menuItem["submenu"] as $li) { ?>
                                                <li>
                                                    <a href="<?= $menuItem['path'] ?>"><img src="/images/<?= $li['img'] ?>" class="icon"><?= $li["text"] ?></a>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                    <?php } ?>
                                </li>
                            <?php } 
                        ?>
                    </ul>
                </nav>
            </div>
        </div>
    </div>
    <div class="header-mobile">
        <div class="container-90">
            <a class="logo"></a>
            <div id="burger">
                <svg class="burger-icon" viewBox="0 0 28 18" aria-hidden="true">
                    <path d="M1 2H27" />
                    <path d="M1 9H27" />
                    <path d="M1 16H27" />
                </svg>
            </div>
        </div>
    </div>
</header>

<ul class="menu-mobile flex-column">
    <?php
        foreach($menu as $menuItem){ ?>
            <li <?php if(!empty($menuItem["class"])){ ?> class="<?= $menuItem["class"]; ?>" <?php } ?>>
                <a href="<?= $menuItem['path'] ?>"><?= $menuItem["text"] ?></a>
                <?php if(!empty($menuItem["submenu"])){ ?>
                    <ul class="submenu">
                        <?php foreach($menuItem["submenu"] as $li) { ?>
                            <li>
                                <a><img src="/images/<?= $li['img'] ?>" class="icon"><?= $li["text"] ?></a>
                            </li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </li>
        <?php } 
    ?>
    <li><a href="<?= $urls[$langue][$lapage] ?>">EN</a></li>
</ul>