const isMobile = window.innerWidth <= 1024;

document.addEventListener("DOMContentLoaded", function(){
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if(entry.isIntersecting) {
                entry.target.classList.add("actif");
                observer.unobserve(entry.target);
            }
            else{
                entry.target.classList.remove("actif");
            }
        });
    }, { threshold: isMobile ? 0.1 : 0.4});

    const oTargets = document.querySelectorAll(".detection");
    oTargets.forEach(target => {
        observer.observe(target);
    });
});