/**
 * Script gérant les modifications css sur le menu dans toutes les pages
 * @author Jean Saposhnikov
 *  
*/

const html = document.querySelector("html");
const burger = document.getElementById("burger");
const menuMobile = document.querySelector(".menu-mobile");
const sousMenuMobile = menuMobile.querySelectorAll(".sous-menu-container");
var oSousMenu=document.querySelectorAll(".has-menu");

burger.addEventListener("click", ()=>{
    menuMobile.classList.toggle("actif");
    burger.classList.toggle("actif");
    html.classList.toggle("disable-scroll");
});


/*
    Pour enregistrer l'action de touch pour laptop et Ipad sur sous-menu
*/

// Si tu ne peux pas hover, et que t'a pas de curseur
if(window.matchMedia("(hover:none), (pointer: coarse)").matches) {
    oSousMenu.forEach(item => {
        item.addEventListener("click", openSubMenu);
    });
}

// Si tu as le hover et un curseur, mais t'es dans une résolution mobile
else{
    if(window.innerWidth < 1025) {
        oSousMenu.forEach(item => {
            item.addEventListener("click", openSubMenu);
        });
    }
}

//Fonction désactivant la navigation de la page catégorie, pour voir les services qui s'ouvrent

function openSubMenu(e){
    if(!this.classList.contains("actif")){ 
        e.preventDefault();
    }
    else{
        menuMobile.classList.remove("actif");
        html.classList.remove("disable-scroll");
        burger.classList.remove("actif");
    }
    this.classList.toggle("actif");
}


/**
 * Fonction modifiant la hauteur de l'entête au scroll
 * @author Jean Saposhnikov
 * 
*/

var oHeader=document.querySelector(".header-screen");

window.onscroll = function(){
    if(window.visualViewport.pageTop > 0.6) {
        oHeader.classList.add("scrolled");
    }

    else {
        oHeader.classList.remove("scrolled");
    }
};

window.addEventListener("resize", function(){

    // Si tu ne peux pas hover, et que t'a pas de curseur
    
    if(window.matchMedia("(hover:none), (pointer: coarse)").matches) {
        oSousMenu.forEach(item => {
            item.removeEventListener("click", openSubMenu);
        });
        oSousMenu.forEach(item => {
            item.addEventListener("click", openSubMenu);
        });
    }

    // Si tu as le hover et un curseur, mais t'es dans une résolution mobile
    else{
        if(window.innerWidth < 1025) {
            oSousMenu.forEach(item => {
                item.removeEventListener("click", openSubMenu);
            });
            oSousMenu.forEach(item => {
                item.addEventListener("click", openSubMenu);
            });
        }
        else{
            oSousMenu.forEach(item => {
                item.removeEventListener("click", openSubMenu);
            });
        }
    }
});
/**
 * Pour liens qui mène vers le bas de la page
 */

/*
const buttonMobile = menuMobile.querySelector(".btn-2");
var oCible = document.querySelector(".section-demande");

buttonMobile.addEventListener("click", function(){
    menuMobile.classList.remove("actif");
    burger.classList.remove("actif");
    oCible.scrollIntoView({behavior: "smooth"});
    html.classList.toggle("disable-scroll");
});
*/